﻿/*
VERSION:	1.2

USAGE:
	#include "makeGrayscale.as"
	grayImage_pic = makeGrayscale( colorImage_pic );
	
NOTE:
	This effect is VERY FAST.
	It took 0.002 seconds to affect Miyamoto.  (2 milliseconds)
*/



makeGrayscale = function( input_pic )
{
	// copy the image
	var output_pic = input_pic.clone();
	
	import flash.filters.ColorMatrixFilter;
	
	var greyMatrix:Array = [0.33,0.33,0.33,0,0,
													0.33,0.33,0.33,0,0,
													0.33,0.33,0.33,0,0,
													0,0,0,1,0 ];
	var greyFilter:ColorMatrixFilter = new ColorMatrixFilter(greyMatrix);
	//color_mc.filters = [greyFilter];
	output_pic.applyFilter( input_pic, input_pic.rectangle, {x:0,y:0}, greyFilter );
	
	
	return output_pic;
}// makeGrayscale()